﻿using System.Collections.Generic;
using System.Linq;

namespace MVC_App.Validation
{
	public interface IErrorTracker
	{
		IErrorTracker Descend(string postfix);
		IErrorTracker DescendIndex(int index);
		void Error(string name, string message);
	}
	
	// Mit Dictionary - Jedes Feld kann seinen "eigenen" Fehler haben. Wird für Joins benötigt.
	// Mehrere Fehler pro Feld sind nicht nötig - das wird durch SelectMany verhindert.
	class ErrorWrapper
	{
	    public ErrorWrapper(IErrorTracker errorTracker, Dictionary<string, string> errors)
	    {
	        _errorTracker = errorTracker;
	        _errors = errors;
	    }

	    private readonly IErrorTracker _errorTracker;
	    private readonly Dictionary<string, string> _errors;

	    public bool HasError { get { return _errors.Any(it => it.Value != null); } }

	    public ErrorWrapper SetError(string errorMessage)
	    {
	    	var res = _errors.ToDictionary(it => it.Key, it => "");

	    	res[res.First().Key] = errorMessage;

	        return new ErrorWrapper(_errorTracker, res);
	    }

	    public void PrintErrors()
	    {
	        foreach (var pair in _errors.Where(it => it.Value != null))
	            _errorTracker.Error(pair.Key, pair.Value);
	    }

	    public ErrorWrapper Merge(ErrorWrapper errorWrapper)
	    {
	        return new ErrorWrapper(_errorTracker, MergeDicts(new [] { _errors, errorWrapper._errors }));
	    }

	    public static Dictionary<TKey, TValue> MergeDicts<TKey, TValue>(IEnumerable<Dictionary<TKey, TValue>> dictionaries)
	    {
	        var result = new Dictionary<TKey, TValue>();
	        foreach (var dict in dictionaries)
	            foreach (var x in dict)
	                result[x.Key] = x.Value;
	        return result;
	    }
	}
}
